# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Deploy a SharePoint solution
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# Site collection branding feature ID
$brandingFeatureId = [GUID]"19e46226-efb9-4761-b09a-cb8711fd503a"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Iterate through each Weh Application
foreach ($webApp in (Get-SPWebApplication))
{
	# Iterate through each Site collection in the Web Application
	foreach ($site in $webApp.Sites)
	{
		# Ensure the Site Collection is in 2013 mode
		if ($site.CompatibilityLevel eq 15)
		{
			# Check if feature is activated, if not, activate it
			if ($site.Features[$brandingFeatureId] -eq $null) 
			{
				$site.Features.Add($brandingFeatureId)
			}				
		}

		# Dispose of the site collection object
		$site.Dispose()
	}
}

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 